module exercise13

import StdEnv, StdiTasks, iDataTrivial

Start world = multiUserTask [ShowUsers 2] (foreverTask exercise11) world

derive gUpd 	Maybe, []
derive gForm 	Maybe, []
derive gParse	Maybe
derive gPrint	Maybe

Me 	:== 0
You :== 1

exercise11 :: Task [Int]
exercise11 
= 					ntttGame InitBoard Me You

ntttGame board me you
=					(me @:> ("You Play", turn me board))
					-||-
					(you @:> ("You Wait", displayBoard board))
	=>> \board ->	if (gameOver me board)
						(stopGame me you board)
						(ntttGame board you me)

displayBoard board 
= 		foreverTask (tttButtons board) #>> return_V board

turn me board 
= 				tttButtons board 
	=>> \i ->	if (freePlace i)
					(return_V (updateAt i me board))
					(turn me board)
where
	freePlace i = board!!i == -1

stopGame me you board
=		(me  @::>  (showBoard -||- [Txt "You won, congratulations!"] ?>> editTask "OK" Void))
		-&&-
		(you @::>  (showBoard -||- [Txt "You lost, sorry!"] ?>> editTask "OK" Void))
	#>>	return_V board
where
	showBoard = tttButtons board <<@ Display #>> return_V Void


OK text = [Txt (toString text)] ?>> editTask "OK" Void

InitBoard = (repeatn 9 -1)

tttButtons board
=	chooseTask [] [(tttButton (board!!i),return_V i) \\ i <- [0..2]]
	-||-
	chooseTask [] [(tttButton (board!!i),return_V i) \\ i <- [3..5]]
	-||-
	chooseTask [] [(tttButton (board!!i),return_V i) \\ i <- [6..8]]
where
	tttButton -1 	= " "
	tttButton Me 	= " O "
	tttButton You 	= " X "

gameOver:: Int [Int] -> Bool
gameOver m [] = False
gameOver m b  
= b%(0,2) == bingo ||			// row
  b%(3,5) == bingo ||
  b%(6,8) == bingo || 
  [b!!0,b!!3,b!!6] == bingo ||	//columns
  [b!!1,b!!4,b!!7] == bingo ||
  [b!!2,b!!5,b!!8] == bingo ||
  [b!!0,b!!4,b!!8] == bingo || // diagonals
  [b!!6,b!!4,b!!2] == bingo
where
	bingo = [m,m,m]

	


